####2D gradient of M9 CAS with galactose (gal) and arabinose - IT013 B::TC3 (para-EC)
# platereader DATA 20160608 (see later replicates: 20190910_2D_gal_CAS_IT013.R)

##?Exclude 1% ara - costly to the cells and no more induction/growth rate change
#revision: see two replicates:  20190904_2D_gal_CAS_IT013.R  (+20190910_2D_gal_CAS_IT013.R)

###### read in data #################################
setwd("/Users/itomanek/Documents/promoter_evolution/experiments/platereader_data/2016_June/2D_BTC3_GAL-CAS")

#OD600
OD=read.csv2("20160608_GAL_OD.txt", header=TRUE, sep="\t") # will read, as . - for OD files from german computers!!
OD$Temperature <- NULL
head(OD)    #need to put "Temperature" into the field for T?? Read 600 in excel
#YFP
YFP=read.csv2("20160608_GAL_YFP.txt", header=TRUE, sep="\t")
YFP$Temperature <- NULL
#PLATE INFO (metadata)
plate_info=read.csv2("20160608_plate_template.txt", header=TRUE, sep="\t")
plate_info$growth_rate <-NULL  #I added gr manually in an older version of script

###### transform time (00:00:00 --> hours) ###########
time<-OD[,1]
time=as.character(time)
time=sapply(strsplit(time,":"),
            function(x) {
              x <- as.numeric(x)
              x[1]+x[2]/60
            })
time=round(time,2)
time #in hours (with minutes as comma)

OD$Time=time  #replace the old time format with time in min 
YFP$Time=time

###### combine data #################################
library("dplyr")
library(reshape2)

###rearrange the data so that each row contains the value for one read of one well
reshaped <- melt(OD, id=c("Time"), variable.name="Well", value.name="OD600")
yfp_reshaped= melt(YFP, id=c("Time"), variable.name="Well",value.name="YFP")

annotated <- inner_join(reshaped, plate_info, by=c("Well") ,copy=TRUE)
annotated <- inner_join(annotated,yfp_reshaped, by=c("Well","Time"), copy=TRUE)
head(annotated)

###### Group data #################################

grouped <- group_by(annotated,Time, Well, ara,gal,glyc)
## extract glyc controls
gly_contr=filter(grouped, glyc==1, strain != "NA", ara!="1.0")

## exclude glyc controls from main data
#grouped=filter(grouped, glyc == 0, strain != "NA", ara != "1.0") #take only gal experiments (where gal=0)
#unique(grouped$ara)

##exclude ara=1% values (harmful conc., expression saturated with less already)
grouped=filter(grouped, ara !=1)
unique(grouped$ara) ##ok. 1% excluded.

grouped$ara = as.numeric(as.character(grouped$ara))
grouped$gal = as.numeric(as.character(grouped$gal))
grouped608=grouped
grouped608$replicate<-"3" #need gr in there see below

###### PLOTS ######################################
#install.packages("ggplot2")
library(ggplot2)
#install.packages("Hmisc")
library("Hmisc")
library("Rmisc")
greys <-c("black","#4D4D4D", "#888888", "#AEAEAE", "#CCCCCC")
Ara_Palette <- c("#E0ECF4" ,"#BFD3E6", "#9EBCDA", "#8C96C6", "#8C6BB1", "#88419D", "#810F7C" ,"#4D004B")
pie(rep(1,8), col=Ara_Palette)
##################### ## ###########################
plot<- ggplot()+ theme_bw()+  #no grey background
  theme(panel.grid.minor = element_blank(),panel.grid.major=element_blank(),text=element_text(size=15)) 

#growth
plot+geom_line(data=grouped, aes(x=Time, y=OD600, group=Well, color=as.factor(gal), linetype=as.factor(ara)))

#growth
plot+geom_line(data=subset(grouped, glyc == 1), aes(x=Time, y=OD600, group=Well, color=as.factor(ara)))

#YFP-OD600  #growth rate needs to be accounted for
plot+geom_line(data=subset(grouped, glyc == 1), aes(x=OD600, y=YFP, group=Well, color=as.factor(ara)))

#YFP nnorm
plot+geom_line(data=subset(grouped, glyc == 1), aes(x=Time, y=YFP, group=Well, color=as.factor(ara)))

plot2<-  theme_bw()+  #no grey background
  theme(panel.grid.minor = element_blank(),panel.grid.major=element_blank(),text=element_text(size=15)) 


##### STEADY STATE FLUORESCENCE YFP ##################
# # sliding window looking for best fit of linear model!
## evaluates max. r^2 of fit and saves those values of intercept+slope
######################################################

#### FUNCTION TO CALCULATE YFP SSF
find_SSFy<- function(OD,YFP) { 
  ##get "range" of well names
  rangewell=(as.character(unique(grouped$Well)))
  
  #create empty list
  max_lm_df <- data.frame()
  rsqu_df <- data.frame()
  library("zoo")
  
  # zooOD changes with each loop (such that each well analysed individually) << zooOD = OD[,i]
  for( j in 1: length(rangewell))  {
    #define zooOD
    zooOD=data.frame(OD[,j+1], YFP[,j+1]) #zooOD consists of 2 columns, second col.changes in loop 
    names(zooOD) <- c("od","yfp") #need constant names
    include=zooOD[1] > 0.1 #set OD threshold (here 0.17, then it gets weird (Platereader evap. etc.))
    zooOD= zooOD[include,]
    #define lm_dataframe
    lm_df <- NULL
    rsqu_df<- NULL
    if( dim(zooOD)[1] < 30 ) { #if too few data points skip
      lm_df <-NA
      rsqu_df <-NA
    }  
    if (dim(zooOD)[1] > 30) { #2nd if 
      lm_df <- rollapply(na.omit(zooOD), width=30, by=5, FUN = function(Z) {  #width=50 sliding window of 50, by=1... sliding window moves one by one, by=50: mean of every 50 values is calculated
        linmods = lm(formula= (yfp) ~ od,data=as.data.frame(Z)); #as.data frame not zoo format here
        return(linmods$coeff); 
      },by.column=FALSE, align="left") #align=whether output indices are start, end, center of sliding window
      #r^2 evaluated of all fits
      rsqu_df <- rollapply(na.omit(zooOD), width=30, by=5, FUN = function(Z) {  #width=50 sliding window of 50, by=1... sliding window moves one by one, by=50: mean of every 50 values is calculated
        linmods = lm(formula= (yfp) ~ od,data=as.data.frame(Z)); #as.data frame not zoo format here
        return(summary(linmods)$r.squared); #get rsquared for the exact same fit as above
      },by.column=FALSE, align="left") #align=whether output indices are start, end, center of sliding window
    }#end 2nd if
    #put together all results
    max_lm_df[j,1] <- rangewell[j] #well name
    if (max(rsqu_df) < 0.2 | is.na(max(rsqu_df))){ #if the max r^2 is too little or 0
      max_lm_df[j,2] <- NA; max_lm_df[j,3] <-NA} else { 
        max_lm_df[j,2] <- lm_df[which.max(rsqu_df),1]  # attach slope+intercept with max r^2 to list 
        max_lm_df[j,3] <- lm_df[which.max(rsqu_df),2]}
    # max_lm_list[j,4] <- lm_df  ##(could store all the slope values if max_lm was list)#tip: get individual dfs out of list with lapply!
  }
  names(max_lm_df) <- c("Well","SSFy_i","SSFy_s")  ##-rename headers for simplicity
  
  return(max_lm_df)
}#function end

#run SSFy function for each 96-well plate (=medium)
max_lm_df <- find_SSFy(OD,YFP)
grouped<- inner_join(grouped, max_lm_df, by= c("Well")) #join by Well


## check yfp_SSFy 
ggplot(subset(grouped))+
  geom_line(aes(x=OD600, y=YFP,color= SSFy_s, group=Well)) #! 

##### #Growth Rates#####################################
# # sliding window looking for best fit of linear model!
## evaluates max. r^2 of fit and saves those values of intercept+slope
########################################################

#### FUNCTION TO CALCULATE GR

find_GR<- function(OD) { 
  ##get "range" of well names
  rangewell=(as.character(unique(grouped$Well)))
  ##create empty list
  max_lm_df <- data.frame()
  head(max_lm_df)
  
  for( j in 1: length(rangewell)) { 
    #define zooOD
    zooOD=data.frame(time, OD[,j+1]) #zooOD consists of 2 columns, second col.changes in loop 
    names(zooOD) <- c("Time","wellname") #need constant names
    #define lm_dataframe
    lm_df <- NULL
    lm_df <- rollapply(zooOD, width=20, by=1, FUN = function(Z) {  #width=50 sliding window of 50, by=1... sliding window moves one by one, by=50: mean of every 50 values is calculated
      linmods = lm(formula= log(wellname) ~ Time,data=as.data.frame(Z)); #as.data frame not zoo format here
      return(linmods$coeff); 
    },by.column=FALSE, align="left") #align=whether output indices are start, end, center of sliding window
    max_lm_df[j,1] <- rangewell[j] #well name
    max_lm_df[j,2] <- lm_df[which.max(lm_df[,2]),1]  # attach max slope+intercept to list 
    max_lm_df[j,3] <- lm_df[which.max(lm_df[,2]),2]
    # max_lm_list[j,4] <- lm_df  ##(could store all the slope values if max_lm was list)#tip: get individual dfs out of list with lapply!
  }
  names(max_lm_df) <- c("Well","GR_i","GR_s")  ##-rename headers for simplicity
  return(max_lm_df)
} #function end

#run find_GR function for each 96-well plate (=medium)
max_lm_df <- find_GR(OD)
grouped<- inner_join(grouped, max_lm_df, by= c("Well")) #join by Well

## check GR
ggplot(subset(grouped, (OD600) >= 0.09 & Time < 10 ))+
  geom_line(aes(x=Time, y=OD600,color= GR_s, group=Well)) #! AWESOME


grouped608=grouped #join with GR_s in there for comparision with other replicate's
############# more PLOTS ###################

####### for TRADEOFF CURVES #############
#####might want to use endpoint ODs instead of growth rates for the tradeoff curves??
grouped=na.omit(grouped)

##get endpoint OD/YFP values
#filter out only the last time point
galEP=filter(annotated, annotated$Time == max(annotated$Time), strain != "NA", glyc == 0, ara != "1.0")
galEP$ara = as.numeric(as.character(galEP$ara))
galEP$gal = as.numeric(as.character(galEP$gal))
head(galEP)

unique(galEP$ara) #ok

####get range of gal values for only endpoint ODs (galEP)
rangegal=unique(grouped$gal)

options(scipen=999) #remove exponential notation (only decimals)
value= NULL
values= NULL
for(i in 1:length(rangegal)) {
  value = rangegal[i]
  values = galEP[galEP$gal == value, ]
  assign(paste0("galEP",rangegal[i], sep=""), values)
}

head(galEP0.05) # it works 


##### plot growth(expression) relations for all gal values #############
ggplot(data=galEP0.001, aes(x=log10(ara), y=OD600, color=log10(gal))) +
  geom_line(data=galEP0) + 
  geom_line(data=galEP0.001) +
  geom_line(data=galEP0.005) +
  geom_line(data=galEP0.01) +
  geom_line(data=galEP0.05) +
  geom_line(data=galEP0.1) +
  geom_line(data=galEP0.5) + 
  geom_line(data=galEP1) +
  labs(x="[ara]", y="end point OD 600") +
  scale_colour_gradientn(colours=rainbow((3))) +
  ggtitle("growth([ara])")   ### nice !! 


##### plot growth(expression) relations for all gal values #############
ggplot() +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.1),aes(x=as.numeric(as.character(ara)), y=GR_s, color=as.numeric(as.character(gal)), group=Well)) + 
  #labs(x="[ara]", y="end point OD 600") +
  scale_colour_gradientn(colours=rainbow((3))) +
  ggtitle("growth([ara])")   ### nice !! 
unique(as.numeric(as.character(grouped$gal)))

#Growth rate versus induction in different gals 
plot(data=subset(grouped, glyc != 1 &gal == 1),GR_s ~ log10(ara), col="black", type="l", ylim=c(0.0,0.6))
points(data=subset(grouped,glyc != 1 & gal == 0.5),GR_s ~ log10(ara), col="brown", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.1),GR_s ~ log10(ara), col="dark red", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.05),GR_s ~ log10(ara), col="red", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.01),GR_s ~ log10(ara), col="purple", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.005),GR_s ~ log10(ara), col="dark blue", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.001),GR_s ~ log10(ara), col=" blue", type="l")
points(data=subset(grouped,glyc != 1 & gal == 0.000),GR_s ~ log10(ara), col=" grey", type="l")

#Growth rate versus induction in different gals 
plot(data=subset(grouped, gal == 1),GR_s ~ log10(as.numeric(ara)), col="black", type="l", ylim=c(0.0,0.6),lwd=2)
points(data=subset(grouped, gal == 0.00),GR_s ~ log10(as.numeric(ara)), col=" grey", type="p", lwd=2)
points(data=subset(grouped, gal == 0.5),GR_s ~ log10(as.numeric(ara)), col="dark blue", type="l",lwd=2)
points(data=subset(grouped, gal == 0.1),GR_s ~ log10(as.numeric(ara)), col="blue", type="l",lwd=2)
points(data=subset(grouped, gal == 0.05),GR_s ~ log10(as.numeric(ara)), col="purple", type="l",lwd=2)
points(data=subset(grouped, gal == 0.01),GR_s ~ log10(as.numeric(ara)), col="dark red", type="l",lwd=2)
points(data=subset(grouped, gal == 0.005),GR_s ~ log10(as.numeric(ara)), col="red", type="l",lwd=2)
points(data=subset(grouped, gal == 0.001),GR_s ~ log10(as.numeric(ara)), col="  orange", type="l",lwd=2)
legend(-1.5,0.6,legend=c("1","0.5","0.1","0.05", "0.01","0.005","0.001","0"), col=c("black","dark blue"," blue", "purple","dark red", "red", "orange", "grey"),lty=1, cex=1.2,box.lty=0)


##### plot growthrate(expression) relations for all gal values #############
ggplot(data=subset(grouped,glyc != 1 & gal == 1), aes(x=log10(ara), y=GR_s, color=log10(gal),group=gal)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 1)) + 
  geom_point(data=subset(grouped,glyc != 1 & gal == 1)) + 
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.5)) + 
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.5)) + 
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.1)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.1)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.01)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.01)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.001)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.001)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0)) +
  labs(x="log ([ara])", y="growth rate") +
  scale_colour_gradientn(colours=rainbow((3))) + theme(text=element_text(size=15)) +
  ggtitle("growth([ara])")   ### nice !! 

##### plot for thesis 
##### plot growthrate(expression) relations for all gal values #############
ggplot(data=subset(grouped,glyc != 1 & gal == 1), aes(x=log10(ara), y=GR_s, color=as.factor(gal),group=gal)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 1)) + 
  geom_point(data=subset(grouped,glyc != 1 & gal == 1)) + 
  #geom_line(data=subset(grouped,glyc != 1 & gal == 0.5)) + 
  #geom_point(data=subset(grouped,glyc != 1 & gal == 0.5)) + 
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.1)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.1)) +
  #geom_line(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0.01)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.01)) +
  #geom_point(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  #geom_line(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  #geom_point(data=subset(grouped,glyc != 1 & gal == 0.001)) +
  #geom_line(data=subset(grouped,glyc != 1 & gal == 0.001)) +
  geom_line(data=subset(grouped,glyc != 1 & gal == 0)) +
  theme_bw()+  #no grey background
  theme(panel.grid.minor = element_blank(),panel.grid.major=element_blank(),text=element_text(size=15)) +
  labs(x="log ([ara])", y="growth rate") +
  scale_colour_manual(values=c("grey","red","dark green","blue")) + theme(text=element_text(size=15)) +
  ggtitle("growth([ara])")   ### nice !! 



####### OR (ggplot with points )
ggplot(data=galEP, aes(x=log10(ara), y=OD600, color=log10(gal))) +
  geom_point(alpha = 0.6, size=5) +     ##alpha adds transparency
  labs(x="ara", y="OD 600") +
  scale_colour_gradientn(colours=rainbow(3)) +
  ggtitle("endpoint OD (induction)")


#yield versus induction in different gals 
sum_yield <-ddply(subset(grouped,glyc==0), c("gal","ara"),summarise,yield=max(OD600))
as.numeric(levels(sum_yield$ara))

#plot(data=subset(sum_yield, gal == 1),(yield) ~ log10(ara), col="black", type="l", ylim=c(0.0,1.5),lwd=2,xlab="log10(ara)",ylab="yield")
plot(data=subset(sum_yield, gal == 1),(yield) ~ log10(ara), col="dark blue", type="l", ylim=c(0.0,1.5),lwd=2,xlab="",ylab="")
points(data=subset(sum_yield, gal == 1),(yield) ~ log10(ara), col=" dark blue", type="p", lwd=2)
points(data=subset(sum_yield, gal == 0.00),(yield) ~ log10(ara), col=" grey", type="l", lwd=2)
points(data=subset(sum_yield, gal == 0.00),(yield) ~ log10(ara), col=" grey", type="p", lwd=2)
points(data=subset(sum_yield, gal == 0.1),(yield) ~ log10(ara), col="blue", type="l",lwd=2)
points(data=subset(sum_yield, gal == 0.1),(yield) ~ log10(ara), col="blue", type="p",lwd=2)
points(data=subset(sum_yield, gal == 0.01),(yield) ~ log10(ara), col="light blue", type="l",lwd=2)
points(data=subset(sum_yield, gal == 0.01),(yield) ~ log10(ara), col="light blue", type="p",lwd=2)

#legend(-1.5,0.6,legend=c("1","0.5","0.1","0.05", "0.01","0.005","0.001","0"), col=c("black","dark blue"," blue", "purple","dark red", "red", "orange", "grey"),lty=1, cex=1.2,box.lty=0)
#revision: to show that population sizes do not differ drastically

### relationship of yield and growth rate
ggplot(data=subset(grouped,glyc != 1 & gal == 1&Time ==max(grouped$Time)), aes(x=(GR_s), y=(OD600), color=log10(gal),group=gal)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 1)) + 
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.5)) + 
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.1)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.01)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.05)) +
  geom_point(data=subset(grouped,glyc != 1 & gal == 0.001)) +
  scale_colour_gradientn(colours=rainbow((3))) + theme(text=element_text(size=15)) +
  ggtitle("growth([ara])")   ### nice !! 

head(grouped)
max(grouped$Time)
########################################################################





######################################################
################## YFP expression in glycerol control 
Ara_Palette <- c("#E0ECF4" ,"#BFD3E6", "#9EBCDA", "#8C96C6", "#8C6BB1", "#88419D", "#810F7C" ,"#4D004B")
pie(rep(1,8), col=Ara_Palette)

## growth of glycerol control
p1= ggplot(data=subset(grouped, gal==0.1 & ara != 1), aes(x=as.numeric(Time), y=OD600, color=(ara), group=Well)) +
  geom_line(size=2) +
  labs(x="Time (hours)", y="OD 600") +scale_colour_manual(values=Ara_Palette[2:length(Ara_Palette)])+
  ggtitle("growth in 0.1% gal")

## YFP (=galK) expression glycerol control
p2=ggplot(data=gly_contr, aes(x=OD600, y=YFP, color=(ara))) +
  geom_line(size=2) +
  labs(x="OD600", y="YFP [a.u.]") +scale_colour_manual(values=Ara_Palette[2:length(Ara_Palette)])+
  ggtitle("YFP expression in glycerol control")

multiplot(p1,p2, cols=2)

#the following two sections (GR, SSFy) were added later, the previous stuff can be deleted


unique(grouped$glyc)

####### plot YFP (full growth curve) + REGRESSION LINE
dev.off()
par(mfrow=c(8,12))
par(mar=c(0.1,0,0,0))
par(oma=c(5,5,5,5))
wellid=YFPr[2:97,1]

for (i in index_range) { #plot all 96 wells in loop, add wellid with paste function
  ODi=OD[,i]
  YFPi=YFP[,i]
  plot(ODi,YFPi, ylim = c(0,max(YFPi)), type = "l", xlab="", ylab="", xaxt="n", yaxt="n")  
  abline(YFPssf_b[i], YFPssf_a[i], col = 2)
  title(paste(wellid[i]), line=-1) #move title downwards
}
#works 

#overview steady state fluorescences YFP
dev.off()
barplot(YFPssf_a, names.arg=YFPr[2:97,1], las=2,cex.names=0.5, main="Steady State Fluorescence YFP", col=topo.colors(12))


######

############
#How to best analyze flourescence data from growth curves
p1=ggplot(data=gly_contr, aes(x=as.numeric(Time)/60, y=OD600, color=(ara))) +
  geom_point() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("growth curves")+
  theme(text=element_text(size=15))

p3=ggplot(data=gly_contr, aes(x=as.numeric(Time)/60, y=YFP, color=(ara))) +
  geom_point() +
  labs(x="Time (hours)", y="YFP [AU]") +
  ggtitle("YFP raw data")+
  theme(text=element_text(size=15))

p2=ggplot(data=gly_contr, aes(x=as.numeric(Time)/60, y=YFP/OD600, color=(ara))) +
  geom_point() +
  labs(x="Time (hours)", y="YFP/OD600 [YFP]") +
  ggtitle("YFP/OD600")+
  theme(text=element_text(size=15))

p4=ggplot(data=subset(gly_contr, OD600 <=0.9 & OD600 >0.25), aes(x=OD600, y=YFP, color=(ara))) +
  geom_point() +
  geom_smooth(data=subset(gly_contr,OD600 <=0.9 & OD600 >0.25), aes(x=OD600, y=YFP),method = "lm", se = FALSE,alpha=0.5 )+
  labs(x="OD600", y="YFP [AU]") +
  ggtitle("YFP-OD plot")+
  theme(text=element_text(size=15))

multiplot(p1,p2,p3,p4,cols=2)
p1
p2
p3
p4

ggplot(data=gly_contr, aes(x=OD600, y=YFP, color=(ara))) +
  geom_point() +
  geom_smooth(data=gly_contr, aes(x=OD600, y=YFP),method = "lm", se = FALSE,alpha=0.5 )+
  labs(x="OD600", y="YFP [AU]") +
  ggtitle("YFP-OD plot")+
  theme(text=element_text(size=15))


###############
#response to reviewers
#full growth curves under different conditions

#varying arabinose in neutral gly (slight cost under high ara)
a=ggplot(data=gly_contr, aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(ara)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("1% glycerol, varying ara")+
  theme(text=element_text(size=10))

#varying arabinose in 0.1% gal (slight cost under high ara)
b=ggplot(data=subset(grouped,gal=="0.1"), aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(ara)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("0.1% gal, varying ara")+
  theme(text=element_text(size=10))

#varying arabinose in 0.01% gal (slight cost under high ara)
c=ggplot(data=subset(grouped,gal=="0.01"), aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(ara)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("0.01% gal, varying ara")+
  theme(text=element_text(size=10))

#varying gal for 0.0% ara (no expression (or very low leaky expression))
d=ggplot(data=subset(grouped,ara=="0"&glyc=="0"), aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(gal)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("0% ara, varying gal")+
  theme(text=element_text(size=10))

#varying gal for 0.0001% ara (slight cost under high ara)
e=ggplot(data=subset(grouped,ara=="0.0001"&glyc=="0"), aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(gal)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("0.0001% ara, varying gal")+
  theme(text=element_text(size=10))


#varying gal for 0.01% ara (slight cost under high ara)
f=ggplot(data=subset(grouped,ara=="0.01"&glyc=="0"), aes(x=as.numeric(Time)/60, y=OD600, color=as.factor(gal)),group_by="Well") +
  geom_line() +
  labs(x="Time (hours)", y="OD600") +
  ggtitle("0.01% ara, varying gal")+
  theme(text=element_text(size=10))

multiplot(a,b,c,d,e,f,cols=3)
